## Model fitting solution

The original loss coefficints are (although the optimizer will not find exact values)

    amodi "PI1" "PI12_LOSS_COEFF" 1.2
    amodi "PI2" "PI12_LOSS_COEFF" 4.6
    amodi "PI3" "PI12_LOSS_COEFF" 2.2
    
Here is one possible solution:

~~~
import "Apros/Sequences"
import "Apros/InitialCondition"
import "Simantics/DB"
import "Simantics/Model"

objFun (p :: [Double]) = do
    print p
    loadInitialCondition (syncRead $ \_ -> fromResource $ relativeResource currentModel "/Initial%20Condition")
    iRef = ref 0
    sqSum = ref (0 :: Double)
    runSequence mdo
        execute do
            setVar "PO1#PO11_PRESSURE" 1.1
            setVar "PI1#PI12_LOSS_COEFF" (p!0)
            setVar "PI2#PI12_LOSS_COEFF" (p!1)
            setVar "PI3#PI12_LOSS_COEFF" (p!2)
        fork (wait 1 >> stop)
        fork $ repeatForever mdo
          wait 0.05
          execute do
              i = getRef iRef
              iRef := i+1
              row = measurements!i
              a = getVar "PI1#PI12_MIX_MASS_FLOW" - row!1 :: Double
              b = getVar "PI2#PI12_MIX_MASS_FLOW" - row!2 :: Double
              c = getVar "PI3#PI12_MIX_MASS_FLOW" - row!3 :: Double
              sqSum := getRef sqSum + a*a + b*b + c*c
    getRef sqSum
~~~

with this definition call

    newuoa 1.0 1e-4 100 objFun [1,1,1]
    
from console.